import torch
import torch.nn as nn
import torch.nn.functional as F

# arch1
# d1 = 300
# d2 = 300
# d3 = 300
# d4 = 300
# d5 = 300

# arch2
# d1 = 1000
# d2 = 1000
# d3 = 1000

#
class SimpleMLP(nn.Module):
    def __init__(self, D_in, D_out, arch):
        super(SimpleMLP, self).__init__()
        d1, d2, d3 = self.arch(arch)
        self.linear1 = nn.Linear(D_in, d1)
        self.linear2 = nn.Linear(d1, d2)
        self.linear3 = nn.Linear(d2, d3)
        self.linear4 = nn.Linear(d3, D_out)


    def arch(self, arch):
        if arch == "small":
            return 200, 200, 200
        if arch == "large":
            return 1200, 1200, 1200
    def forward(self, x):
        x = x.view(x.size(0), -1)
        x = F.relu(self.linear1(x))
        x = F.relu(self.linear2(x))
        x = F.relu(self.linear3(x))
        x = self.linear4(x)
        return x



class SimpleCNN(nn.Module):
    def __init__(self, D_in, D_out, arch):
        super(SimpleCNN, self).__init__()
        d1, d2, d3 = self.arch(arch)
        self.cnn1 = nn.Conv2D(D_in, d1)
        self.linear2 = nn.Linear(d1, d2)
        self.linear3 = nn.Linear(d2, d3)
        self.linear4 = nn.Linear(d3, D_out)


    def arch(self, arch):
        if arch == "small":
            return 200, 200, 200
        if arch == "large":
            return 1200, 1200, 1200
    def forward(self, x):
        x = x.view(x.size(0), -1)
        x = F.relu(self.linear1(x))
        x = F.relu(self.linear2(x))
        x = F.relu(self.linear3(x))
        # x = F.relu(self.linear4(x))
        # x = F.relu(self.linear5(x))
        x = self.linear4(x)
        return x


class C_LeNet(nn.Module):
    def __init__(self):
        super(C_LeNet, self).__init__()
        self.conv1 = nn.Conv2d(3, 6, 5)
        self.conv2 = nn.Conv2d(6, 16, 5)
        self.linear3 = nn.Linear(16 * 5 * 5, 120)
        self.linear4 = nn.Linear(120, 84)
        self.linear5 = nn.Linear(84, 10)

    def forward(self, x):
        x = F.avg_pool2d(F.relu(self.conv1(x)), (2, 2))
        x = F.avg_pool2d(F.relu(self.conv2(x)), 2)
        x = torch.flatten(x, 1)
        x = F.relu(self.linear3(x))
        x = F.relu(self.linear4(x))
        x = self.linear5(x)
        return x


class LeNet(nn.Module):
    def __init__(self):
        super(LeNet, self).__init__()
        self.conv1 = nn.Conv2d(1, 6, 5)
        self.conv2 = nn.Conv2d(6, 16, 5)
        self.linear3 = nn.Linear(16 * 5 * 5, 120)
        self.linear4 = nn.Linear(120, 84)
        self.linear5 = nn.Linear(84, 10)

    def forward(self, x):
        x = F.avg_pool2d(F.relu(self.conv1(x)), (2, 2))
        x = F.avg_pool2d(F.relu(self.conv2(x)), 2)
        x = torch.flatten(x, 1)
        x = F.relu(self.linear3(x))
        x = F.relu(self.linear4(x))
        x = self.linear5(x)
        return x

class L_LeNet(nn.Module):
    def __init__(self):
        super(L_LeNet, self).__init__()
        self.conv1 = nn.Conv2d(1, 16, 5)
        self.conv2 = nn.Conv2d(16, 32, 5)
        self.linear3 = nn.Linear(32 * 5 * 5, 240)
        self.linear4 = nn.Linear(240, 84)
        self.linear5 = nn.Linear(84, 10)

    def forward(self, x):
        x = F.avg_pool2d(F.relu(self.conv1(x)), (2, 2))
        x = F.avg_pool2d(F.relu(self.conv2(x)), 2)
        x = torch.flatten(x, 1)
        x = F.relu(self.linear3(x))
        x = F.relu(self.linear4(x))
        x = self.linear5(x)
        return x